import math
import matplotlib.pyplot as plt
import matplotlib.animation as animation

a, f = 5, 3
num, delta_t = 100, 0.01
t, y = [], []

fig, ax = plt.subplots()
line, = plt.plot(t, y, marker='o')

def init():

    ax.set_xlim(0, (num-1)*delta_t)
    ax.set_ylim(-a, a)
    ax.set_xlabel('Time (s)')
    ax.set_ylabel('Sine-Wave Displacement (cm)')
    
    return line,

def animate(i, t, y):
   
    t_i = i*delta_t
    y_i = a*math.sin(2.0*math.pi*f*t_i)

    t.append(t_i)
    y.append(y_i)

    line.set_data(t, y)

    return line,

ani = animation.FuncAnimation(fig, animate, frames=num,
                              fargs=(t, y), interval=100,
                              init_func=init, repeat=False,
                              blit=True)

plt.show()

